package com.envisioniot.enos.model_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.api.common.constant.response.AbstractEnosRsp;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.ToString;

import java.util.Map;

/**
 * @author qiwei.tan
 * @version 1.0
 * @program enos-commons-parent
 * @ClassName AbstractModelRequest
 * @Description TODO
 * @date 2020/5/19 12:19
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
abstract class AbstractModelRequest extends PoseidonRequest {
    @Getter
    private static final String BASE_URI = "/model-service/v2.1/thing-models";

    @Override
    public String baseUri() {
        return BASE_URI;
    }

    @Override
    public String method() {
        return "POST";
    }

    /**
     * return action name
     *
     * @return action name
     */
    protected abstract String action();

    /**
     * request 's response class
     * @param <T>
     * @return
     */
    public abstract <T extends AbstractEnosRsp> Class<T> getResponseClass();
}
