package com.envisioniot.enos.logic_asset_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.asset_tree_service.vo.AssetCreateVo;
import com.envisioniot.enos.logic_asset_service.vo.AssetUpdateVo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class UpdateLogicAssetRequest extends PoseidonRequest
{
    private String orgId;
    private AssetUpdateVo asset;
    private Boolean isPartialUpdate;

    @Override
    public String baseUri()
    {
        return "/asset-service/v2.1/logical-assets";
    }

    @Override
    public String method()
    {
        return "POST";
    }

    @Override
    public Map<String, Object> queryParams()
    {
        Map<String, Object> params = new HashMap<>();
        params.put("action", "update");
        params.put("orgId", orgId);
        params.put("isPartialUpdate", isPartialUpdate);
        return params;

    }

    @Override
    public Map<String, Object> bodyParams()
    {
        Map<String, Object> params = new HashMap<>();
        params.put("assetUpdateVo", asset);
        return params;
    }
}

