package com.envisioniot.enos.event_service.vo.condition;


import com.envisioniot.enos.event_service.vo.condition.operator.SimpleOperator;

/**
 * simple condition without complex logic
 * for datapoint of struct type, simple condition can between two items, eg: name > anotherName
 * @author hongjie.shan
 * @date 2018/12/14
 */
public class SimpleCondition<T> extends AbstractCondition {

    private static final long serialVersionUID = 7323204636373943214L;

    private final ConditionType conditionType = ConditionType.SIMPLE;

    /**
     * field name
     * for simple measurepoint: mpName
     * for struct measurepoint: mpName/item
     */
    private String name;

    private SimpleOperator operator;

    private T value;

    public SimpleCondition() {
    }

    /**
     * construct simple condition, compare <name> with <value>
     * @param name
     * @param operator
     * @param value
     */
    public SimpleCondition(String name, SimpleOperator operator, T value) {
        this.name = name;
        this.operator = operator;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SimpleOperator getOperator() {
        return operator;
    }

    public void setOperator(SimpleOperator operator) {
        this.operator = operator;
    }

    public T getValue() {
        return value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public ConditionType getConditionType() {
        return conditionType;
    }

}
