package com.envisioniot.enos.event_service.vo.condition;


import com.envisioniot.enos.event_service.vo.condition.operator.RangeOperator;

/**
 * range condition without complex logic
 * @author hongjie.shan
 * @date 2018/12/17
 */
public class RangeCondition<T> extends AbstractCondition {

    private static final long serialVersionUID = 7323204636373943214L;

    private final ConditionType conditionType = ConditionType.RANGE;

    private String name;

    private RangeOperator operator;

    /**
     * left value of the range condition
     */
    private T leftValue;

    /**
     * right value of the range condition
     */
    private T rightValue;

    public RangeCondition() {
    }

    /**
     * construct simple range condition
     * @param name
     * @param operator
     * @param leftValue
     * @param rightValue
     */
    public RangeCondition(String name, RangeOperator operator, T leftValue, T rightValue) {
        this.name = name;
        this.operator = operator;
        this.leftValue = leftValue;
        this.rightValue = rightValue;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RangeOperator getOperator() {
        return operator;
    }

    public void setOperator(RangeOperator operator) {
        this.operator = operator;
    }

    public T getLeftValue() {
        return leftValue;
    }

    public void setLeftValue(T leftValue) {
        this.leftValue = leftValue;
    }

    public T getRightValue() {
        return rightValue;
    }

    public void setRightValue(T rightValue) {
        this.rightValue = rightValue;
    }

    @Override
    public ConditionType getConditionType() {
        return conditionType;
    }


}
