package com.envisioniot.enos.event_service.vo.condition;


import com.envisioniot.enos.event_service.vo.condition.operator.RangeOperator;
import com.envisioniot.enos.event_service.vo.condition.operator.SimpleOperator;

import java.util.List;

/**
 * @author hongjie.shan
 * @date 2018/12/15
 */
public class ConditionFactory {

    //-----------simple section-----------

    /**
     *
     * create simple EQ condition
     * @param name measure point id
     * @param value
     * @param <T>
     * @return
     */
    public static <T> SimpleCondition createSimpleEQ(final String name, final T value){
        SimpleCondition<T> simpleCondition = new SimpleCondition<T>(name, SimpleOperator.EQ, value);
        return simpleCondition;
    }

    public static <T> SimpleCondition createSimpleNE(final String name, final T value){
        SimpleCondition<T> simpleCondition = new SimpleCondition<T>(name, SimpleOperator.NE, value);
        return simpleCondition;
    }

    public static <T> SimpleCondition createSimpleGT(final String name, final T value){
        SimpleCondition<T> simpleCondition = new SimpleCondition<T>(name, SimpleOperator.GT, value);
        return simpleCondition;
    }

    public static <T> SimpleCondition createSimpleGTE(final String name, final T value){
        SimpleCondition<T> simpleCondition = new SimpleCondition<T>(name, SimpleOperator.GTE, value);
        return simpleCondition;
    }

    public static <T> SimpleCondition createSimpleLT(final String name, final T value){
        SimpleCondition<T> simpleCondition = new SimpleCondition<T>(name, SimpleOperator.LT, value);
        return simpleCondition;
    }

    public static <T> SimpleCondition createSimpleLTE(final String name, final T value){
        SimpleCondition<T> simpleCondition = new SimpleCondition<T>(name, SimpleOperator.LTE, value);
        return simpleCondition;
    }

    public static SimpleCondition<String> createSimpleCONTAIN(final String name, final String value){
        SimpleCondition<String> simpleCondition = new SimpleCondition<String>(name,
                SimpleOperator.CONTAIN, value);
        return simpleCondition;
    }

    //-----------relative section-----------

    /**
     *
     * create simple EQ condition
     * @param name measure point id
     * @param anotherName another measure point id in the same struct
     * @return
     */
    public static RelativeCondition createRelativeEQ(final String name, final String anotherName){
        RelativeCondition simpleCondition = new RelativeCondition(name, SimpleOperator.EQ, anotherName);
        return simpleCondition;
    }

    public static RelativeCondition createRelativeNE(final String name, final String anotherName){
        RelativeCondition simpleCondition = new RelativeCondition(name, SimpleOperator.NE, anotherName);
        return simpleCondition;
    }

    public static RelativeCondition createRelativeGT(final String name, final String anotherName){
        RelativeCondition simpleCondition = new RelativeCondition(name, SimpleOperator.GT, anotherName);
        return simpleCondition;
    }

    public static RelativeCondition createRelativeGTE(final String name, final String anotherName){
        RelativeCondition simpleCondition = new RelativeCondition(name, SimpleOperator.GTE, anotherName);
        return simpleCondition;
    }

    public static RelativeCondition createRelativeLT(final String name, final String anotherName){
        RelativeCondition simpleCondition = new RelativeCondition(name, SimpleOperator.LT, anotherName);
        return simpleCondition;
    }

    public static RelativeCondition createRelativeLTE(final String name, final String anotherName){
        RelativeCondition simpleCondition = new RelativeCondition(name, SimpleOperator.LTE, anotherName);
        return simpleCondition;
    }

    public static RelativeCondition createRelativeCONTAIN(final String name, final String anotherName){
        RelativeCondition simpleCondition = new RelativeCondition(name, SimpleOperator.CONTAIN, anotherName);
        return simpleCondition;
    }

    //-----------range section-----------
    public static <T> RangeCondition createRangeLCRC(final String name, final T leftValue, final T rightValue){
        RangeCondition<T> rangeCondition = new RangeCondition<T>(name, RangeOperator.RANGE_LCRC, leftValue, rightValue);
        return rangeCondition;
    }

    public static <T> RangeCondition createRangeLCRO(final String name, final T leftValue, final T rightValue){
        RangeCondition<T> rangeCondition = new RangeCondition<T>(name, RangeOperator.RANGE_LCRO, leftValue, rightValue);
        return rangeCondition;
    }

    public static <T> RangeCondition createRangeLORC(final String name, final T leftValue, final T rightValue){
        RangeCondition<T> rangeCondition = new RangeCondition<T>(name, RangeOperator.RANGE_LORC, leftValue, rightValue);
        return rangeCondition;
    }

    public static <T> RangeCondition createRangeLORO(final String name, final T leftValue, final T rightValue){
        RangeCondition<T> rangeCondition = new RangeCondition<T>(name, RangeOperator.RANGE_LORO, leftValue, rightValue);
        return rangeCondition;
    }

    //-----------logical section-----------

    public static NotCondition createNotCondition(final AbstractCondition condition){
        NotCondition notCondition = new NotCondition(condition);
        return notCondition;
    }

    public static AndCondition createAndCondition(final List<AbstractCondition> conditions){
        AndCondition andCondition = new AndCondition(conditions);
        return andCondition;
    }

    public static OrCondition createOrCondition(final List<AbstractCondition> conditions){
        OrCondition orCondition = new OrCondition(conditions);
        return orCondition;
    }

}
