package com.envisioniot.enos.event_service.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public class AlertRuleVo implements Serializable {

    private String orgId;
    /**
     * 用户规则编号
     */
    private String ruleId;
    private StringI18n ruleDesc;
    private String modelId;

    private String measurepointId;
    private String deviceStatus;
    /**
     * 触发条件,类sql语法
     */
    private String condition;


    /**
     * 这个enabled理论上不应该使用的
     */
    private Boolean isEnabled = true;

    private String severityId;

    private StringI18n severityDesc;

    private String contentId;

    private StringI18n contentDesc;

    private String typeId;

    private StringI18n typeDesc;

    /**
     * 是否是根源告警规则
     */
    private Boolean isRoot;

    private List<AssetNode> scope;

    private Map<String,String> tags = new HashMap<>();

    private String source;

    private Integer triggeringDelayTimer;
}
