package com.envisioniot.enos.event_service.v2_1;

import com.envisioniot.enos.event_service.vo.GenerateType;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class UpdateAlertTypeRequest extends AbstractAlertTypeRequest{
    private String orgId;
    private GenerateType type;
    private Boolean isPatchUpdate;

    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", "update");
        map.put("orgId", orgId);
        if (isPatchUpdate != null) {
            map.put("isPatchUpdate", isPatchUpdate);
        }
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", "update");
        if (type != null) {
            map.put("type", type);
        }

        return map;
    }
}
