package com.envisioniot.enos.event_service.v2_1;

import com.envisioniot.enos.event_service.vo.GenerateContent;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class UpdateAlertContentRequest extends AbstractAlertContentRequest{
    private String orgId;
    private GenerateContent alertContent;
    private Boolean isPatchUpdate;

    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", "update");
        map.put("orgId", orgId);
        if (isPatchUpdate != null) {
            map.put("isPatchUpdate", isPatchUpdate);
        }
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", "update");
        if (alertContent != null) {
            map.put("alertContent", alertContent);
        }

        return map;
    }
}
