package com.envisioniot.enos.event_service.v2_1;

import com.envisioniot.enos.api.common.constant.request.Pagination;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * Desc:
 *
 * @author zhonghua.wu
 * @date 2019/5/24 20:17
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class SearchAlertSeverityRequest extends AbstractAlertSeverityRequest {

    private String orgId;
    private String expression;
    private Pagination pagination;

    @Override
    public String baseUri() {
        return super.baseUri();
    }

    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", "search");
        map.put("orgId", orgId);
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", "search");
        if (expression != null) {
            map.put("expression", expression);
        }
        if (pagination != null) {
            map.put("pagination", pagination);
        }
        return map;
    }

}
