package com.envisioniot.enos.event_service.v2_1;

import com.envisioniot.enos.api.common.constant.request.Pagination;
import lombok.Data;

import java.util.HashMap;
import java.util.Map;

@Data
public class SearchAlertRuleRequest extends AbstractAlertRuleRequest {
    private String orgId;
    private String modelId;
    private String measurepointId;
    private String expression;
    private Pagination pagination;

    @Override
    public String baseUri() {
        return super.baseUri();
    }

    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", "search");
        map.put("orgId", orgId);
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", "search");
        if (modelId != null) {
            map.put("modelId", modelId);
        }
        if (measurepointId != null) {
            map.put("measurepointId", measurepointId);
        }
        if (expression != null) {
            map.put("expression", expression);
        }
        if (pagination != null) {
            map.put("pagination", pagination);
        }
        return map;
    }
}
