package com.envisioniot.enos.event_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.api.common.constant.request.Pagination;
import com.envisioniot.enos.event_service.vo.RootAlert;
import com.envisioniot.enos.event_service.vo.Scope;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class SearchActiveAlertRequest extends PoseidonRequest {

    private String orgId;
    private String modelId;
    private String assetId;
    private String measurepointId;
    private String treeId;
    private String maskedBy;
    private Boolean isMasked;
    private String startOccurTime;
    private String endOccurTime;
    private String expression;
    private Pagination pagination;
    private Scope scope;
    private RootAlert rootAlert;

    @Override
    public Map<String, Object> queryParams() {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "search");
        params.put("orgId", orgId);
        return params;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "search");

        if(modelId != null){
            params.put("modelId",modelId);
        }
        if(assetId != null){
            params.put("assetId",assetId);
        }
        if(measurepointId != null){
            params.put("measurepointId",measurepointId);
        }
        if(treeId != null){
            params.put("treeId",treeId);
        }
        if(maskedBy != null){
            params.put("maskedBy",maskedBy);
        }
        if(isMasked != null){
            params.put("isMasked",isMasked);
        }
        if(startOccurTime != null){
            params.put("startOccurTime",startOccurTime);
        }
        if(endOccurTime != null){
            params.put("endOccurTime",endOccurTime);
        }
        if(expression != null){
            params.put("expression",expression);
        }
        if (pagination != null)
        {
            params.put("pagination", pagination);
        }
        if (scope != null)
        {
            params.put("scope", scope);
        }
        if (rootAlert != null)
        {
            params.put("rootAlert", rootAlert);
        }
        return params;
    }

    @Override
    public String baseUri() {
        return "/event-service/v2.1/active-alerts";
    }

    @Override
    public String method() {
        return  "POST";
    }
}
