package com.envisioniot.enos.event_service.v2_1;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class DeleteAlertContentRequest extends AbstractAlertContentRequest{
    private String orgId;
    private String alertContentId;
    private String source;

    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", "delete");
        map.put("orgId", orgId);
        map.put("alertContentId", alertContentId);
        map.put("source", source);
        return map;
    }
}
