package com.envisioniot.enos.event_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.event_service.vo.GenerateHistoryAlert;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class CreateHistoryAlertRequest extends PoseidonRequest {

    private String orgId;
    private GenerateHistoryAlert historyAlert;


    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", "create");
        map.put("orgId", orgId);
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        final Map<String, Object> map = new HashMap<>();
        map.put("action", "create");
        if (historyAlert != null) {
            map.put("historyAlert", historyAlert);
        }
        return map;
    }

    @Override
    public String baseUri() {
        return "/event-service/v2.1/history-alerts";
    }

    @Override
    public String method() {
        return  "POST";
    }
}
