package com.envisioniot.enos.event_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.event_service.vo.GenerateHistoryAlert;
import lombok.Data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public class BatchCreateHistoryAlertsRequest extends PoseidonRequest {
    private String orgId;
    private List<GenerateHistoryAlert> historyAlertList;

    @Override
    public Map<String, Object> queryParams() {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "batchCreate");
        params.put("orgId", orgId);
        return params;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "batchCreate");
        if(historyAlertList != null){
            params.put("historyAlertList",historyAlertList);
        }
        return params;
    }

    @Override
    public String baseUri() {
        return "/event-service/v2.1/history-alerts";
    }

    @Override
    public String method() {
        return  "POST";
    }
}
