package com.envisioniot.enos.connect_service.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * Desc: 唯一标记一个device，
 * assetId或者productKey+deviceKey, 二选一，都填写时以assetId为主
 *
 * @author zhonghua.wu
 * @date 2019/6/16 16:14
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DeviceIdentifier implements Serializable {
    private static final long serialVersionUID = -4945878197734035629L;

    private String assetId;
    private String productKey;
    private String deviceKey;

    public DeviceIdentifier(String assetId) {
        this.assetId = assetId;
        this.productKey = null;
        this.deviceKey = null;
    }

    public DeviceIdentifier(String productKey, String deviceKey) {
        this.assetId = null;
        this.productKey = productKey;
        this.deviceKey = deviceKey;
    }

    public DeviceIdentifier setAssetId(String assetId) {
        this.assetId = assetId;
        return this;
    }

    public DeviceIdentifier setKey(String productKey, String deviceKey) {
        this.productKey = productKey;
        this.deviceKey = deviceKey;
        return this;
    }

}
