package com.envisioniot.enos.connect_service.vo;

import com.envisioniot.enos.api.common.constant.common.StringI18n;
import lombok.Data;

import java.io.Serializable;

/**
* @Description:
* @Author:         yanting.wu
* @CreateDate:     2019/4/9 17:53
*/
@Data
public class CommandResponse implements Serializable
{
    private static final long serialVersionUID = -8213887640118115361L;

    private String commandId;

    private String orgId;

    private String productKey;

    private String deviceKey;           // 通过AssetId 查出来
    
    private String assetId;             // productKey + deviceKey 查出来的。

    private long createTime;
    
    private String createLocaltime;
    
    private int commandType;            //  see CommandTypeEnum   1. 测点设置  2. 服务调用
    
    private StringI18n commandName;  // 命令的名称，对于测点设置来说，就是测点的名称；
                                        // 对于服务调用来说，就是服务的名称
                                        // 通过 TSLModel 算出来的。
    
    private int timeout;                // 命令执行的超时时间

    private int pendingTtl;             // 0. 即时命令， 非0. 缓存命令

    //命令状态,默认值为已创建
    private int state;
    
    private String tslIdentifier;

    private Object inputData;

    private Object outputData;


}
