package com.envisioniot.enos.connect_service.v2_2.product.private_req;

import com.envisioniot.enos.api.common.constant.common.StringI18n;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @author zhonghua.wu
 * @date 2019-07-18
 */

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class PrivateCreateProductRequest extends AbstractPrivateProductRequest {

    private String orgId;

    private String modelId;
    private String productKey;
    private String productSecret;
    private StringI18n productName;
    private String productDesc;

    private String dataFormat;
    private String productType;
    private Boolean biDirectionalAuth;
    private Boolean dynamicActivateEnabled;
    private Set<String> protocolGatewayIds;
    private Map<String, String> productTags;

    private Integer maxValidDay;
    private Integer defaultValidDay;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>(2);
        map.put("action", action());
        if (orgId != null) {
            map.put("orgId", orgId);
        }
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String, Object> map = new HashMap<>(13);
        if (modelId != null) {
            map.put("modelId", modelId);
        }
        if (productKey != null) {
            map.put("productKey", productKey);
        }
        if (productSecret != null) {
            map.put("productSecret", productSecret);
        }
        if (productName != null) {
            map.put("productName", productName);
        }
        if (productDesc != null) {
            map.put("productDesc", productDesc);
        }
        if (dataFormat != null) {
            map.put("dataFormat", dataFormat);
        }
        if (productType != null) {
            map.put("productType", productType);
        }
        if (biDirectionalAuth != null) {
            map.put("biDirectionalAuth", biDirectionalAuth);
        }
        if (dynamicActivateEnabled != null) {
            map.put("dynamicActivateEnabled", dynamicActivateEnabled);
        }
        if (protocolGatewayIds != null) {
            map.put("protocolGatewayIds", protocolGatewayIds);
        }
        if (productTags != null) {
            map.put("productTags", productTags);
        }
        if (maxValidDay != null) {
            map.put("maxValidDay", maxValidDay);
        }
        if (defaultValidDay != null) {
            map.put("defaultValidDay", defaultValidDay);
        }
        return map;

    }

    @Override
    public String action() {
        return "create";
    }
}
