package com.envisioniot.enos.connect_service.v2_1.service;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.api.common.constant.request.Pagination;
import com.envisioniot.enos.api.common.constant.request.Projection;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class SearchCommandRequest extends PoseidonRequest
{
    private String orgId;

    private String productKey;

    private String deviceKey;

    private String assetId;

    private String expression;

    private Pagination pagination;
    
    private Projection projection;

    @Override
    public Map<String, Object> queryParams()
    {
        Map<String, Object> params = new HashMap<>();
        params.put("action", "search");
        params.put("orgId", orgId);
        if (productKey != null)
        {
            params.put("productKey", productKey);
        }
        if (deviceKey != null)
        {
            params.put("deviceKey", deviceKey);
        }
        if (assetId != null)
        {
            params.put("assetId", assetId);
        }
        return params;
    }
    
    @Override
    public Map<String, Object> bodyParams()
    {
        Map<String, Object> params = new HashMap<>();
        if (expression != null)
        {
            params.put("expression", expression);
        }
        if (pagination != null)
        {
            params.put("pagination", pagination);
        }
        if (projection != null)
        {
            params.put("projection", projection);
            
        }
        return params;
    }

    @Override
    public String baseUri()
    {
        return "/connect-service/v2.1/commands";
    }

    @Override
    public String method()
    {
        return "POST";
    }

}
