package com.envisioniot.enos.connect_service.v2_1.service;

import com.envision.apim.poseidon.request.PoseidonRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class CancelCommandRequest extends PoseidonRequest {
    private String orgId;
    private String productKey;
    private String deviceKey;
    private String assetId;
    private String commandId;

    @Override
    public Map<String, Object> queryParams() {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "cancel");
        params.put("orgId", orgId);
        params.put("productKey",productKey);
        params.put("deviceKey",deviceKey);
        params.put("assetId",assetId);
        params.put("commandId",commandId);
        return params;
    }


    @Override
    public String baseUri() {
        return "/connect-service/v2.1/commands";
    }


    @Override
    public String method() {
        return  "GET";
    }

}
