package com.envisioniot.enos.connect_service.v2_1.product;

import com.envisioniot.enos.api.common.constant.common.StringI18n;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class UpdateProductRequset extends AbstractProductRequest {

    private String orgId;
    private String productKey;

    private StringI18n productName;
    private String productDesc;
    private Boolean dynamicActivateEnabled;
    private Boolean biDirectionalAuth;
    private Map<String, String> productTags;

    private Integer maxValidDay;
    private Integer defaultValidDay;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>();
        map.put("action", action());
        if (orgId != null) {
            map.put("orgId", orgId);
        }
        if (productKey != null) {
            map.put("productKey", productKey);
        }
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String, Object> map = new HashMap<>();
        if (productName != null) {
            map.put("productName", productName);
        }
        if (productDesc != null) {
            map.put("productDesc", productDesc);
        }
        if (dynamicActivateEnabled != null) {
            map.put("dynamicActivateEnabled", dynamicActivateEnabled);
        }
        if (biDirectionalAuth != null) {
            map.put("biDirectionalAuth", biDirectionalAuth);
        }
        if (productTags != null) {
            map.put("productTags", productTags);
        }
        if(maxValidDay != null){
            map.put("maxValidDay", maxValidDay);
        }
        if (defaultValidDay != null){
            map.put("defaultValidDay",defaultValidDay);
        }
        return map;
    }

    @Override
    String action() {
        return "update";
    }
}
