package com.envisioniot.enos.connect_service.v2_1.product;

import com.envision.apim.poseidon.request.PoseidonRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class GetProductRequest extends AbstractProductRequest {

    private String orgId;
    private String productKey;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> params = new HashMap<>();
        params.put("action", action());
        if (orgId != null) {
            params.put("orgId", orgId);
        }
        if (productKey != null) {
            params.put("productKey", productKey);
        }
        return params;
    }

    @Override
    public String method() {
        return "GET";
    }

    @Override
    String action() {
        return "get";
    }
}
