package com.envisioniot.enos.connect_service.v2_1.ota.job.task;

import com.envisioniot.enos.api.common.constant.request.Pagination;
import com.envisioniot.enos.connect_service.v2_1.ota.job.AbstractJobRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * @author :charlescai
 * @date :2020-06-02
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class SearchTaskRequest extends AbstractJobRequest {
    private String orgId;
    private String expression;
    private Pagination pagination;

    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>(2);
        map.put("action", action());
        if (orgId != null) {
            map.put("orgId", orgId);
        }
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        final Map<String, Object> map = new HashMap<>(2);
        if (expression != null) {
            map.put("expression", expression);
        }
        if (pagination != null) {
            map.put("pagination", pagination);
        }
        return map;
    }

    @Override
    protected String action() {
        return "searchTask";
    }
}
