package com.envisioniot.enos.connect_service.v2_1.ota.job.task;

import com.envisioniot.enos.connect_service.v2_1.ota.job.AbstractJobRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * @author :charlescai
 * @date :2020-06-02
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class CancelTaskRequest extends AbstractJobRequest {
    private String orgId;
    private String jobId;
    private Set<String> deviceKeys;


    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>(4);
        map.put("action", action());
        if (orgId != null) {
            map.put("orgId", orgId);
        }
        if (jobId != null) {
            map.put("jobId", jobId);
        }
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        final Map<String, Object> map = new HashMap<>(2);
        if (deviceKeys != null) {
            map.put("deviceKeys", deviceKeys);
        }
        return map;
    }

    @Override
    protected String action() {
        return "cancelTask";
    }
}
