package com.envisioniot.enos.connect_service.v2_1.ota.job;

import com.envisioniot.enos.api.common.constant.common.StringI18n;
import com.envisioniot.enos.connect_service.vo.ota.RetryPolicy;
import com.envisioniot.enos.connect_service.vo.ota.SchedulePolicy;
import com.envisioniot.enos.connect_service.vo.ota.UpgradeScope;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * @author :charlescai
 * @date :2020-06-01
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class CreateJobRequest extends AbstractJobRequest {
    private String orgId;
    private String firmwareId;

    private StringI18n name;
    private String type;
    private String upgradePolicy;
    private UpgradeScope upgradeScope;
    private SchedulePolicy schedulePolicy;
    private RetryPolicy retryPolicy;
    private Boolean enableUpgradeRequest;
    private Integer maximumConcurrency;
    private Long upgradeTimeout;

    @Deprecated
    private Long startSchedule;
    @Deprecated
    private Long endSchedule;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>(2);
        map.put("action", action());
        if (orgId != null) {
            map.put("orgId", orgId);
        }
        if (firmwareId != null) {
            map.put("firmwareId", firmwareId);
        }
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String, Object> map = new HashMap<>(10);
        if (name != null) {
            map.put("name", name);
        }
        if (type != null) {
            map.put("type", type);
        }
        if (upgradePolicy != null) {
            map.put("upgradePolicy", upgradePolicy);
        }
        if (upgradeScope != null) {
            map.put("upgradeScope", upgradeScope);
        }
        if (schedulePolicy != null) {
            map.put("schedulePolicy", schedulePolicy);
        }
        if (retryPolicy != null) {
            map.put("retryPolicy", retryPolicy);
        }
        if (enableUpgradeRequest != null) {
            map.put("enableUpgradeRequest", enableUpgradeRequest);
        }
        if (maximumConcurrency != null) {
            map.put("maximumConcurrency", maximumConcurrency);
        }
        if (startSchedule != null) {
            map.put("startSchedule", startSchedule);
        }
        if (endSchedule != null) {
            map.put("endSchedule", endSchedule);
        }
        if (upgradeTimeout != null) {
            map.put("upgradeTimeout", upgradeTimeout);
        }
        return map;
    }

    @Override
    protected String action() {
        return "create";
    }
}
