package com.envisioniot.enos.connect_service.v2_1.ota.job;

import com.envision.apim.poseidon.request.PoseidonRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * @author :charlescai
 * @date :2020-06-01
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
abstract public class AbstractJobRequest extends PoseidonRequest {
    public static final String BASE_URI = "/connect-service/v2.1/ota-jobs";

    @Override
    public String baseUri() {
        return BASE_URI;
    }

    @Override
    public String method() {
        return "POST";
    }

    /**
     * return action name
     *
     * @return action name
     */
    protected abstract String action();
}
