package com.envisioniot.enos.connect_service.v2_1.multi_protocol.haystack;

import com.envisioniot.enos.connect_service.v2_1.multi_protocol.haystack.vo.PointInfo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author mengyuantan
 * @date 2021/2/19 14:59
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class UpdatePointsRequest extends AbstractHaystackRequest {

    private String orgId;

    private boolean isPartialUpdate = true;
    private List<PointInfo> points;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>(2);
        map.put("action", action());
        if (orgId != null) {
            map.put("orgId", orgId);
        }
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String, Object> map = new HashMap<>(2);
        map.put("isPartialUpdate", isPartialUpdate);
        if (points != null) {
            map.put("points", points);
        }
        return map;
    }

    @Override
    protected String action() {
        return "updatePoints";
    }
}
