package com.envisioniot.enos.connect_service.v2_1.measurepoints;

import com.envision.apim.poseidon.request.PoseidonRequest;
import lombok.Data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public class QueryLatestMeasurepointsRequest extends PoseidonRequest {
    private String orgId;
    private String assetId;
    private String productKey;
    private String deviceKey;

    private List<String> measurepointIds;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>(5);
        map.put("action", "queryLatest");
        if (orgId != null) {
            map.put("orgId", orgId);
        }
        if (assetId != null) {
            map.put("assetId", assetId);
        }
        if (productKey != null) {
            map.put("productKey", productKey);
        }
        if (deviceKey != null) {
            map.put("deviceKey", deviceKey);
        }
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        if (hasMeasurepointIds()) {
            Map<String, Object> body = new HashMap<>(1);
            body.put("measurepointIds", measurepointIds);
            return  body;
        }
        return super.bodyParams();
    }

    @Override
    public String baseUri() {
        return "/connect-service/v2.1/measurepoints";
    }

    @Override
    public String method() {
        return "POST";
    }

    private boolean hasMeasurepointIds() {
        return measurepointIds != null && measurepointIds.size() > 0;
    }
}
