package com.envisioniot.enos.connect_service.v2_1.event;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.api.common.constant.request.Pagination;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class SearchEventRequest extends PoseidonRequest {


    private String orgId;
    private String productKey;
    private String deviceKey;
    private String assetId;
    private String tslEventKey;
    private String tslEventType;
    private String startTime;
    private String endTime;
    private String expression;
    private Pagination pagination;
    private Boolean resolveName;

    @Override
    public Map<String, Object> queryParams() {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "search");
        params.put("orgId", orgId);
        return params;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "search");

        if(productKey != null){
            params.put("productKey",productKey);
        }
        if(deviceKey != null){
            params.put("deviceKey",deviceKey);
        }
        if(assetId != null){
            params.put("assetId",assetId);
        }
        if(tslEventKey != null){
            params.put("tslEventKey",tslEventKey);
        }
        if(tslEventType != null){
            params.put("tslEventType",tslEventType);
        }
        if(startTime != null){
            params.put("startTime",startTime);
        }
        if(endTime != null){
            params.put("endTime",endTime);
        }
        if(expression != null){
            params.put("expression",expression);
        }
        if (pagination != null)
        {
            params.put("pagination", pagination);
        }
        if (resolveName != null)
        {
            params.put("resolveName", resolveName);
        }
        return params;
    }

    @Override
    public String baseUri() {
        return "/connect-service/v2.1/events";
    }

    @Override
    public String method() {
        return  "POST";
    }

}
