package com.envisioniot.enos.connect_service.v2_1.device.topo;

import com.envisioniot.enos.api.common.constant.request.Pagination;
import com.envisioniot.enos.api.common.constant.request.Projection;
import com.envisioniot.enos.connect_service.vo.DeviceIdentifier;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * Desc:
 *
 * @author zhonghua.wu
 * @date 2019/6/16 15:39
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class SearchSubDeviceRequest extends AbstractDeviceTopoRequest {

    private String orgId;
    private DeviceIdentifier gateway;
    private String expression;
    private Pagination pagination;
    private Projection projection;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>(3);
        map.put("action", action());
        if (orgId != null) {
            map.put("orgId", orgId);
        }

        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String, Object> map = new HashMap<>();
        if (gateway != null) {
            map.put("gateway", gateway);
        }
        if (expression != null) {
            map.put("expression", expression);
        }
        if (pagination != null) {
            map.put("pagination", pagination);
        }
        if (projection != null) {
            map.put("projection", projection);
        }
        return map;
    }

    @Override
    protected String action() {
        return "searchSubDevice";
    }
}
