package com.envisioniot.enos.connect_service.v2_1.device.topo;

import com.envisioniot.enos.connect_service.vo.DeviceIdentifier;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Desc:
 *
 * @author zhonghua.wu
 * @date 2019/6/16 15:39
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class RemoveSubDeviceRequest extends AbstractDeviceTopoRequest {

    private String orgId;
    private DeviceIdentifier gateway;
    private List<DeviceIdentifier> subDevices;

    @Override
    public Map<String, Object> queryParams() {
        Map<String, Object> map = new HashMap<>(2);
        map.put("action", action());
        map.put("orgId", orgId);
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String, Object> map = new HashMap<>(2);
        if (gateway != null) {
            map.put("gateway", gateway);
        }
        if (subDevices != null) {
            map.put("subDevices", subDevices);
        }
        return map;
    }


    @Override
    protected String action() {
        return "removeSubDevice";
    }
}
