package com.envisioniot.enos.connect_service.v2_1.connection_topos.vo;

import com.envisioniot.enos.api.common.constant.common.StringI18n;
import lombok.Data;

import javax.annotation.Nullable;

@Data
public class NodeInfoVo {

    private String ou;

    /**
     * 用于唯一识别一个拓扑连接
     */
    private String rootAssetId;

    private String nodeId;

    /**
     * 每部分由assetId（设备节点）或者nodeId（虚拟节点）构成
     */
    private String nodePath;

    /**
     * 只有设备节点才有这个信息，虚拟节点没有
     */
    @Nullable
    private String assetId;

    private StringI18n name;

    /**
     * edge端上报拓扑状态时，自己提供的时间戳
     */
    private long reportTime;

    private long lastConnectedTime;
    private int state;

    /**
     * 节点上报的额外信息，比如节点变为离线的原因
     */
    @Nullable
    private String info;

    private boolean isLeaf;

    /**
     * This would only be set if the node corresponds to an asset
     */
    @Nullable
    private String timezone;
}
