package com.envisioniot.enos.connect_service.v2_1.connection_topos;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author mengyuantan
 * @date 2021/1/25 23:08
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class GetDevicePathsRequest extends AbstractTopoRequest {

    private String orgId;
    private List<String> assetIds;

    @Override
    public Map<String, Object> queryParams() {
        final Map<String, Object> map = new HashMap<>(2);
        map.put("action", action());
        map.put("orgId", orgId);
        return map;
    }

    @Override
    public Map<String, Object> bodyParams() {
        final Map<String, Object> map = new HashMap<>(4);
        map.put("action", action());
        if (assetIds != null) {
            map.put("assetIds", assetIds);
        }
        return map;
    }

    @Override
    protected String action() {
        return "getDevicePaths";
    }
}
