package com.envisioniot.enos.connect_service.v2_1.cert;

import lombok.*;

/**
 * @author qiwei.tan
 * @version 1.0
 * @program enos-commons-parent
 * @ClassName RevokeReason
 * @Description 证书理由
 * @date 2019/12/2 21:47
 */
public interface   RevokeReason {
    /**
     * 此原因表明未确定证书为何被吊销
     */
    Integer UNSPECIFIED = 0;
    /**
     * 此原因表明已知或怀疑证书使用者的私钥已被破坏
     */
    Integer KEY_COMPROMISE = 1;
    /**
     * 此原因表明主体的名称或其他信息已更改
     */
    Integer AFFILIATION_CHANGED = 3;
    /**
     * 此原因表明证书已被取代。比如证书更新请求后原证书撤销
     */
    Integer SUPERSEDED = 4;
    /**
     * 此原因表明不再需要该证书
     */
    Integer CESSATION_OF_OPERATION = 5;
    /**
     * 此原因表明证书已被搁置,冻结等
     */
    Integer CERTIFICATE_HOLD = 6;
    /**
     * 此原因表明授予证书主体的授权已被撤消,即认为CA已经无效,没有权限授权证书,该证书已经不可信
     */
    Integer PRIVILEGE_WITHDRAWN = 9;
}
