package com.envisioniot.enos.connect_service.v2_1.cert;

import lombok.*;

import java.util.Map;

/**
 * @author qiwei.tan
 * @version 1.0
 * @program enos-commons-parent
 * @ClassName RenewCertificateRequest
 * @Description 更新证书
 * @date 2019/12/2 15:52
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
public class RenewCertificateRequest extends ApplyCertificateRequest {
    private Integer certSn;

    @Override
    public Map<String, Object> bodyParams() {
        Map<String, Object> map = super.bodyParams();
        if(certSn != null){
            map.put("certSn", certSn);
        }
        return map;
    }

    @Override
    protected String action() {
        return "renew";
    }
}
