package com.envisioniot.enos.connect_service.v2_1.cert;

import com.google.common.collect.Maps;
import lombok.*;

import java.util.Map;

/**
 * @author qiwei.tan
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@AllArgsConstructor
public class ApplyCertificateRequest extends AbstractCertificateRequest {

    private String csr;
    private Integer validDay;
    private String issueAuthority;

    @Override
    public Map<String, Object> bodyParams() {
        Map<String, Object> map = Maps.newHashMap();
        if(csr != null){
            map.put("csr", csr);
        }
        if(validDay != null){
            map.put("validDay", validDay);
        }
        if(issueAuthority != null){
            map.put("issueAuthority", issueAuthority);
        }
        return map;

    }

    @Override
    protected String action() {
        return "apply";
    }

}