package com.envisioniot.enos.asset_tree_service.vo;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 这个类描述了在查询AssetNode时，可以指定的查询条件
 * @author shenjieyuan
 */
@Data
public class RelatedAssetSearchVo implements Serializable
{
    // 资产ID相关的查询条件
    // 如果是想查多个ID，就传多个值
    // 如果只想查一个ID，就传一个值
    private List<String> assetIds;

    // 模型相关的查询条件
    private List<String> modelIds;
    
    private List<String> rootModelIds;
    
    private I18nSearchVo nameLike;
    
    // 资产树上关系的查询条件，4种关系条件里面最多支持1个，提供关联的assetId
    private String isParentOfAssetId;
    
    private String isChildOfAssetId;
    
    private String isAncestorOfAssetId;
    
    private String isDescendantOfAssetId;
}
