package com.envisioniot.enos.asset_tree_service.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import lombok.Data;
import lombok.Value;



/**
 * 这个类定义了一组AssetPath。它由两个部分组成，第一部分是assetId的链条，第二部分是assetId与asset详情的对照关系表
 * @author shenjieyuan
 */
@Value
@Data
public class AssetPathVo implements Serializable
{

    // 一组assetId组成的路径
    private List<List<String>> assetPaths;

    // 一个assetId与asset详情的映射表
    private Map<String/*assetId*/,AssetVo> assets;
    
    /**
     * 获取包含资产详细信息的路径列表
     * @return
     */
    public List<List<AssetVo>> queryDetailedAssetPathes()
    {
        List<List<AssetVo>> result =new ArrayList<>();
        for (List<String> inner : assetPaths) {
            List<AssetVo> innerList = new ArrayList<>();
            for (String assetId : inner) {
                innerList.add(assets.get(assetId));
            }
            result.add(innerList);
        }
        return result;
    }
}
