package com.envisioniot.enos.asset_tree_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.asset_tree_service.vo.AssetCreateVo;
import com.envisioniot.enos.asset_tree_service.vo.TreeUpdateVo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class UpdateTreeRequest extends PoseidonRequest {
    private String orgId;
    private TreeUpdateVo treeUpdateInfo;

    @Override
    public String baseUri()
    {
        return "/asset-tree-service/v2.1/asset-trees";
    }

    @Override
    public String method()
    {
        return "POST";
    }

    @Override
    public Map<String, Object> queryParams()
    {
        Map<String, Object> params = new HashMap<>();
        params.put("action", "update");
        params.put("orgId", orgId);
        return params;
    }

    @Override
    public Map<String, Object> bodyParams()
    {
        Map<String, Object> params = new HashMap<>();
        params.put("treeUpdateInfo", treeUpdateInfo);
        return params;
    }
}
