package com.envisioniot.enos.asset_tree_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.api.common.constant.request.Projection;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)

public class SearchAssetTreeByAssetIdsRequest extends PoseidonRequest
{
    private String orgId;
    
    private List<String> assetIds;

    private Projection projection;

    @Override
    public String baseUri()
    {
        return "/asset-tree-service/v2.1/asset-nodes";
    }

    @Override
    public String method()
    {
        return "POST";
    }
    
    @Override
    public Map<String,Object> queryParams()
    {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "getAssetTree");
        params.put("orgId", orgId);
        return params;
    }

    @Override
    public Map<String,Object> bodyParams()
    {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "getAssetTree");

        if (assetIds != null)
        {
            params.put("assetIds", assetIds);
        }

        if (projection != null)
        {
            params.put("projection", projection);
        }

        return params;
    }
}
