package com.envisioniot.enos.asset_tree_service.v2_1;

import java.util.HashMap;
import java.util.Map;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.api.common.constant.request.Pagination;
import com.envisioniot.enos.api.common.constant.request.Projection;
import com.envisioniot.enos.asset_tree_service.vo.AssetTreePathSearchEndVo;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class SearchAssetPathRequest extends PoseidonRequest{


    private String orgId;
    
    private String treeId;
    
    private AssetTreePathSearchEndVo from;
    
    private AssetTreePathSearchEndVo to;
    
    private String pathProjection;
    
    private Projection projection;
    
    private Pagination pagination;

    @Override
    public String baseUri()
    {
        return "/asset-tree-service/v2.1/asset-paths";
    }

    @Override
    public String method()
    {
        return "POST";
    }
    
    @Override
    public Map<String,Object> queryParams()
    {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "search");
        params.put("orgId", orgId);
        params.put("treeId", treeId);
        return params;
    }

    @Override
    public Map<String,Object> bodyParams()
    {
        Map<String,Object> params = new HashMap<>();
        if (from != null)
        {
            params.put("from", from);
        }
        if (to != null)
        {
            params.put("to", to);
        }
        if (pathProjection!=null)
        {
            params.put("pathProjection", pathProjection);
        }
        if (projection != null)
        {
            params.put("projection", projection);
        }
        if (pagination != null)
        {
            params.put("pagination", pagination);
        }
        return params;
    }



}
