package com.envisioniot.enos.asset_tree_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.api.common.constant.request.Pagination;
import com.envisioniot.enos.api.common.constant.request.Projection;
import com.envisioniot.enos.asset_tree_service.vo.AssetSearchVo;
import com.envisioniot.enos.asset_tree_service.vo.TreeSearchVo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)

public class SearchAssetNodeRequest extends PoseidonRequest
{
    private String orgId;
    private String expression;
    @Deprecated
    private AssetSearchVo filter;
    private Pagination pagination;
    private Projection projection;

    @Override
    public String baseUri()
    {
        return "/asset-tree-service/v2.1/asset-nodes";
    }

    @Override
    public String method()
    {
        return "POST";
    }
    
    @Override
    public Map<String,Object> queryParams()
    {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "searchAsset");
        params.put("orgId", orgId);
        return params;
    }

    @Override
    public Map<String,Object> bodyParams()
    {
        Map<String,Object> params = new HashMap<>();
        if (expression!=null&&!expression.isEmpty()){
            params.put("expression", expression);
        }
        if (filter != null)
        {
            params.put("filter", filter);
        }
        if (projection != null)
        {
            params.put("projection", projection);
        }
        if (pagination != null)
        {
            params.put("pagination", pagination);
        }
        return params;
    }


}
