package com.envisioniot.enos.asset_tree_service.v2_1;

import java.util.HashMap;
import java.util.Map;

import com.envision.apim.poseidon.request.PoseidonRequest;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class GetAssetTreeRequest extends PoseidonRequest
{
    private String orgId;
    private String treeId;

    @Override
    public String baseUri()
    {
        return "/asset-tree-service/v2.1/asset-trees";
    }

    @Override
    public String method()
    {
        return "GET";
    }

    @Override
    public Map<String,Object> queryParams()
    {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "get");
        params.put("orgId", orgId);
        params.put("treeId", treeId);
        return params;
    }
}
