package com.envisioniot.enos.asset_tree_service.v2_1;

import java.util.HashMap;
import java.util.Map;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.asset_tree_service.vo.AssetCreateVo;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)

public class CreateAssetNodeRequest extends PoseidonRequest
{
    private String orgId;
    private String treeId;
    private String parentAssetId;
    private AssetCreateVo asset;

    @Override
    public String baseUri()
    {
        return "/asset-tree-service/v2.1/asset-nodes";
    }

    @Override
    public String method()
    {
        return "POST";
    }

    @Override
    public Map<String, Object> queryParams()
    {
        Map<String, Object> params = new HashMap<>();
        params.put("action", "createAsset");
        params.put("orgId", orgId);
        params.put("treeId", treeId);
        params.put("parentAssetId", parentAssetId);

        return params;

    }

    @Override
    public Map<String, Object> bodyParams()
    {
        Map<String, Object> params = new HashMap<>();



        params.put("asset", asset);
        return params;
    }
}
