package com.envisioniot.enos.asset_tree_service.v2_1;


import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.asset_tree_service.vo.TreeCreateVo;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class AssociateTreeRequest extends PoseidonRequest {
    private String orgId;
    private String assetId;
    private String productKey;
    private String deviceKey;
    private TreeCreateVo tree;

    @Override
    public String baseUri()
    {
        return "/asset-tree-service/v2.1/asset-trees";
    }

    @Override
    public String method()
    {
        return "POST";
    }

    @Override
    public Map<String, Object> queryParams()
    {
        Map<String, Object> params = new HashMap<>();
        params.put("action", "associate");
        params.put("orgId", orgId);
        if (assetId!=null) {
            params.put("assetId", assetId);
        }
        if (productKey!=null) {
            params.put("productKey", productKey);
        }
        if (deviceKey!=null) {
            params.put("deviceKey", deviceKey);
        }
        return params;
    }
    
    @Override
    public Map<String, Object> bodyParams()
    {
        Map<String, Object> params = new HashMap<>();
        params.put("tree", tree);
        return params;
    }
}
