package com.envisioniot.enos.asset_tree_service.v2_1;

import java.util.HashMap;
import java.util.Map;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.asset_tree_service.vo.AssetCreateVo;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class AssociateAssetNodeRequest extends PoseidonRequest{

    private String orgId;
    private String treeId;
    private String parentAssetId;
    private String assetId;
    private String productKey;
    private String deviceKey;

    @Override
    public String baseUri()
    {
        return "/asset-tree-service/v2.1/asset-nodes";
    }

    @Override
    public String method()
    {
        return "POST";
    }

    @Override
    public Map<String, Object> queryParams()
    {
        Map<String, Object> params = new HashMap<>();
        params.put("action", "associateAsset");
        params.put("orgId", orgId);
        params.put("treeId", treeId);
        params.put("parentAssetId", parentAssetId);
        if (assetId!=null) {
            params.put("assetId", assetId);
        }
        if (productKey!=null) {
            params.put("productKey", productKey);
        }
        if (deviceKey!=null) {
            params.put("deviceKey", deviceKey);
        }
        return params;
    }

}
