package com.envisioniot.enos.asset_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import com.envisioniot.enos.asset_service.vo.AssetUpdateVo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * @version v2.1
 * @author hongjie.shan
 * @date 2019/5/24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class UpdateAssetRequest extends PoseidonRequest {
    private String orgId;

    private AssetUpdateVo asset;

    private Boolean isPatchUpdate;

    @Override
    public String baseUri() {
        return "/asset-service/v2.1/assets";
    }

    @Override
    public String method() {
        return "POST";
    }

    @Override
    public Map<String, Object> queryParams()
    {
        Map<String, Object> params = new HashMap<>();
        params.put("action", "update");
        params.put("isPatchUpdate", isPatchUpdate);
        params.put("orgId", orgId);

        return params;

    }

    @Override
    public Map<String, Object> bodyParams()
    {
        Map<String, Object> params = new HashMap<>();

        params.put("asset", asset);
        return params;
    }

    public Class<UpdateAssetResponse> getResponseClass() {
        return UpdateAssetResponse.class;
    }
}
