package com.envisioniot.enos.asset_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * @version v2.1
 * @author hongjie.shan
 * @date 2019/5/24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class GetAssetRequest extends PoseidonRequest {

    private String orgId;

    private String assetId;

    @Override
    public String baseUri() {
        return "/asset-service/v2.1/assets";
    }

    @Override
    public String method() {
        return "GET";
    }

    @Override
    public Map<String, Object> queryParams()
    {
        Map<String, Object> params = new HashMap<>();
        params.put("action", "get");

        params.put("orgId", orgId);
        params.put("assetId", assetId);

        return params;

    }

    public Class<GetAssetResponse> getResponseClass() {
        return GetAssetResponse.class;
    }
}
