package com.envisioniot.enos.alert_service.v2_1;

import com.envision.apim.poseidon.request.PoseidonRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.HashMap;
import java.util.Map;

/**
 * @author haifeng.zhu
 * @date 2021/3/15
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class CloseAlertRequest extends PoseidonRequest {
    private String orgId;
    private String alertId;
    private Long recoverTime;
    private String localRecoverTime;
    private String recoverReason;


    @Override
    public Map<String, Object> queryParams() {
        Map<String,Object> params = new HashMap<>();
        params.put("action", "close");
        params.put("orgId", orgId);
        return params;
    }

    @Override
    public Map<String, Object> bodyParams() {
        Map<String,Object> params = new HashMap<>();
        if(alertId != null){
            params.put("alertId",alertId);
        }
        if(recoverTime != null){
            params.put("recoverTime",recoverTime);
        }
        if(localRecoverTime != null){
            params.put("localRecoverTime",localRecoverTime);
        }
        if(recoverReason != null){
            params.put("recoverReason",recoverReason);
        }
        return params;
    }

    @Override
    public String baseUri() {
        return "/alert-service/v2.1/alerts";
    }

    @Override
    public String method() {
        return  "POST";
    }
}
