/*
 * Decompiled with CFR 0.152.
 */
package com.envision.apim.poseidon.util;

import com.alibaba.fastjson.JSON;
import com.envision.apim.poseidon.config.PConfig;
import com.envision.apim.poseidon.core.PoseidonReq;
import com.envision.apim.poseidon.expand.ProxyAuthenticator;
import com.envision.apim.poseidon.interceptor.ApimInterceptor;
import com.envision.apim.poseidon.interceptor.UploadInterceptor;
import com.envision.apim.poseidon.util.StringUtils;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;

public class OkHttpUtils {
    private static volatile OkHttpUtils okHttpUtils;
    private final ConcurrentHashMap<String, OkHttpClient> httpClientMap = new ConcurrentHashMap(6);
    private static X509TrustManager x509TrustManager;

    private static TrustManager[] getTrustManager() {
        x509TrustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        return new TrustManager[]{x509TrustManager};
    }

    public static SSLSocketFactory getSSLSocketFactory() {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, OkHttpUtils.getTrustManager(), new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static HostnameVerifier getHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpUtils getInstance() {
        if (okHttpUtils != null) return okHttpUtils;
        Class<OkHttpUtils> clazz = OkHttpUtils.class;
        synchronized (OkHttpUtils.class) {
            if (okHttpUtils != null) return okHttpUtils;
            okHttpUtils = new OkHttpUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return okHttpUtils;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OkHttpClient getHttpClient(PConfig pConfig, PoseidonReq poseidonReq) {
        String key = pConfig.getMapKey();
        OkHttpClient client = this.httpClientMap.get(key);
        if (!poseidonReq.isFormData() && client != null) {
            return client;
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        PConfig.ProxyConfig proxyConfig = pConfig.getProxyConfig();
        if (proxyConfig != null) {
            builder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyConfig.getIp(), (int)proxyConfig.getPort())));
            String userName = proxyConfig.getUserName();
            String password = proxyConfig.getPassword();
            builder.proxyAuthenticator((Authenticator)new ProxyAuthenticator(userName, password));
        }
        if (!pConfig.isVerifySSL()) {
            builder.sslSocketFactory(OkHttpUtils.getSSLSocketFactory(), x509TrustManager).hostnameVerifier(OkHttpUtils.getHostnameVerifier());
        }
        if (!pConfig.isAutoRedirect()) {
            builder.followRedirects(false);
            if (poseidonReq.isFormData()) {
                builder.addInterceptor((Interceptor)new UploadInterceptor(poseidonReq));
            } else {
                builder.addInterceptor((Interceptor)new ApimInterceptor());
            }
        }
        if (pConfig.getProtocols() != null) {
            builder.protocols(pConfig.getProtocols());
        }
        if (pConfig.getInterceptor() != null) {
            builder.addInterceptor(pConfig.getInterceptor());
        }
        client = builder.connectTimeout(pConfig.getConnectTimeout(), TimeUnit.MILLISECONDS).writeTimeout(pConfig.getWriteTimeout(), TimeUnit.MILLISECONDS).readTimeout(pConfig.getReadTimeout(), TimeUnit.MILLISECONDS).build();
        if (pConfig.getMaxRequests() != null) {
            client.dispatcher().setMaxRequests(pConfig.getOkHttpMaxRequests().intValue());
            client.dispatcher().setMaxRequestsPerHost(pConfig.getMaxRequests().intValue());
        }
        if (!poseidonReq.isFormData() || pConfig.isAutoRedirect()) {
            ConcurrentHashMap<String, OkHttpClient> concurrentHashMap = this.httpClientMap;
            synchronized (concurrentHashMap) {
                this.httpClientMap.put(key, client);
            }
        }
        return client;
    }

    public static String getFileNameByContentDisPosition(String contentDisposition) {
        String filename = System.currentTimeMillis() + "";
        if (StringUtils.isEmpty(contentDisposition)) {
            return filename;
        }
        for (String s : contentDisposition.split(";")) {
            if (!s.trim().startsWith("filename")) continue;
            filename = s.substring(s.indexOf("=") + 1).trim();
            break;
        }
        return filename;
    }

    public static boolean isStream(String subtype) {
        if (subtype == null) {
            return false;
        }
        return subtype.contains("octet-stream");
    }

    public static MultipartBody buildMultipartBody(Map<String, Object> reqMap) {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder.setType(MultipartBody.FORM);
        for (Map.Entry<String, Object> entry : reqMap.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof File) {
                File file = (File)value;
                String fileName = file.getName();
                builder.addFormDataPart(entry.getKey(), fileName, RequestBody.create(null, (File)file));
                continue;
            }
            if (value instanceof String) {
                builder.addFormDataPart(entry.getKey(), null, RequestBody.create(null, (String)value.toString()));
                continue;
            }
            builder.addFormDataPart(entry.getKey(), null, RequestBody.create((MediaType)MediaType.parse((String)"application/json;charset=utf-8"), (String)JSON.toJSONString((Object)value)));
        }
        return builder.build();
    }
}

