/*
 * Decompiled with CFR 0.152.
 */
package com.envision.apim.poseidon.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.envision.apim.poseidon.config.PConfig;
import com.envision.apim.poseidon.constants.Constants;
import com.envision.apim.poseidon.core.PoseidonListener;
import com.envision.apim.poseidon.core.PoseidonReq;
import com.envision.apim.poseidon.core.PoseidonResponse;
import com.envision.apim.poseidon.exception.PoseidonException;
import com.envision.apim.poseidon.request.IPoseidonRequest;
import com.envision.apim.poseidon.util.CollectionUtils;
import com.envision.apim.poseidon.util.OkHttpUtils;
import com.envision.apim.poseidon.util.SecurityUtils;
import com.envision.apim.poseidon.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpMethod;

public final class Poseidon
implements Callback {
    private static final Map<String, String> ACCESS_TOKEN_MAPS = new ConcurrentHashMap<String, String>(3);
    private Map<String, String> gHeaders = new HashMap<String, String>(2);
    private Map<String, String> gFormParams = new HashMap<String, String>(2);
    private Map<String, String> gFormEncodeParams = new HashMap<String, String>(2);
    private Map<String, Object> gFormData = new HashMap<String, Object>(2);
    private String gRequestBody;
    private String gUrl = "http://apim-apigw.enos.svc.cluster.local:8000";
    private String gMethod;
    private String filePath = "/data/file";
    private String fileName;
    private boolean isOverride;
    private PConfig pConfig;
    private PoseidonListener listener;
    private static final String pattern = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final StringBuffer sb;

    private Poseidon(PConfig pConfig) {
        this.pConfig = pConfig;
    }

    public static Poseidon config(PConfig pConfig) {
        if (StringUtils.isEmpty(pConfig.getAppKey()) || StringUtils.isEmpty(pConfig.getAppSecret())) {
            throw new PoseidonException("AppKey or AppSecret is invalid");
        }
        return new Poseidon(pConfig);
    }

    public Poseidon url(String url) {
        this.gUrl = url;
        return this;
    }

    public Poseidon method(String method) {
        this.gMethod = method.toUpperCase();
        return this;
    }

    public Poseidon get() {
        this.gMethod = "GET";
        return this;
    }

    public Poseidon post() {
        this.gMethod = "POST";
        return this;
    }

    public Poseidon put() {
        this.gMethod = "PUT";
        return this;
    }

    public Poseidon patch() {
        this.gMethod = "PATCH";
        return this;
    }

    public Poseidon delete() {
        this.gMethod = "DELETE";
        return this;
    }

    public Poseidon path(String path) {
        this.gUrl = this.gUrl + path;
        return this;
    }

    public Poseidon requestBody(String requestBody) {
        this.gRequestBody = requestBody;
        return this;
    }

    public Poseidon header(String k, String v) {
        this.gHeaders.put(k, v);
        return this;
    }

    public Poseidon formParam(String k, String v) {
        this.gFormParams.put(k, v);
        return this;
    }

    public Poseidon formEncodeParam(String k, String v) {
        this.gFormEncodeParams.put(k, v);
        return this;
    }

    public Poseidon formData(String k, Object v) {
        this.gFormData.put(k, v);
        return this;
    }

    public Poseidon queryParam(String k, String v) {
        if (!this.gUrl.contains("?")) {
            this.gUrl = this.gUrl + "?";
        }
        if (!this.gUrl.endsWith("&") && !this.gUrl.endsWith("?")) {
            this.gUrl = this.gUrl + "&";
        }
        this.gUrl = this.gUrl + k + "=" + v;
        return this;
    }

    public Poseidon fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Poseidon filePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public Poseidon isOverride(boolean isOverride) {
        this.isOverride = isOverride;
        return this;
    }

    public <T> T getResponse(IPoseidonRequest baseRequest, Class<T> responseClass) throws PoseidonException {
        return (T)JSON.parseObject((String)this.sync(this.parseRequestParams(baseRequest)), responseClass);
    }

    private PoseidonReq parseRequestParams(IPoseidonRequest request) {
        PoseidonReq poseidonRS = new PoseidonReq();
        poseidonRS.headers = request.headerParams().isEmpty() ? this.gHeaders : request.headerParams();
        poseidonRS.url = this.gUrl + request.baseUri();
        if (!request.pathParams().isEmpty()) {
            poseidonRS.url = this.generatePathParams(poseidonRS.url, request.pathParams());
        }
        if (!request.queryParams().isEmpty() || !request.queryEncodeParams().isEmpty()) {
            poseidonRS.url = poseidonRS.url + this.generateQueryParams(request.queryParams(), request.queryEncodeParams());
        }
        if (!request.bodyParams().isEmpty()) {
            poseidonRS.requestBody = JSON.toJSONString(request.bodyParams());
        }
        if (!StringUtils.isEmpty(request.jsonBodyString())) {
            if (poseidonRS.requestBody != null) {
                throw new PoseidonException("bodyParams and jsonBodyString not coexist");
            }
            poseidonRS.requestBody = request.jsonBodyString();
        }
        poseidonRS.method = StringUtils.isEmpty(request.method()) ? this.gMethod : request.method();
        if (!request.formParams().isEmpty()) {
            poseidonRS.formParams = request.formParams();
        }
        if (!request.formEncodeParams().isEmpty()) {
            poseidonRS.formEncodeParams = request.formEncodeParams();
        }
        poseidonRS.formData = request.formData();
        return poseidonRS;
    }

    private String generatePathParams(String uri, Map<String, Object> pathParams) {
        for (Map.Entry<String, Object> entry : pathParams.entrySet()) {
            uri = uri.replaceAll("\\{" + entry.getKey() + "\\}", entry.getValue().toString());
        }
        return uri;
    }

    private String generateQueryParams(Map<String, Object> queryParams, Map<String, Object> queryEncodeParams) {
        StringBuilder urlBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : queryParams.entrySet()) {
            if (entry.getValue() == null) continue;
            urlBuilder.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        if (queryEncodeParams != null) {
            for (Map.Entry<String, Object> entry : queryEncodeParams.entrySet()) {
                if (entry.getValue() == null) continue;
                try {
                    urlBuilder.append(entry.getKey()).append("=").append(URLEncoder.encode(String.valueOf(entry.getValue()), "UTF-8")).append("&");
                }
                catch (UnsupportedEncodingException e) {
                    throw new PoseidonException(e);
                }
            }
        }
        if (urlBuilder.length() > 0) {
            urlBuilder.deleteCharAt(urlBuilder.lastIndexOf("&"));
            return "?" + urlBuilder.toString();
        }
        return "";
    }

    public String sync() throws PoseidonException {
        return this.sync(new PoseidonReq(this.gUrl, this.gMethod, this.gRequestBody, this.gFormParams, this.gFormEncodeParams, this.gHeaders, this.gFormData));
    }

    private boolean processRequestFile(Response response) throws IOException {
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            throw new PoseidonException("response body is null");
        }
        boolean isStream = Poseidon.isStreamType(response);
        if (isStream) {
            if (StringUtils.isEmpty(this.fileName)) {
                this.fileName = OkHttpUtils.getFileNameByContentDisPosition(response.header("Content-Disposition"));
            }
            if (!this.filePath.endsWith(File.separator)) {
                this.filePath = this.filePath + File.separator;
            }
            Files.createDirectories(Paths.get(this.filePath, new String[0]), new FileAttribute[0]);
            Path path = Paths.get(this.filePath + this.fileName, new String[0]);
            File file = path.toFile();
            if (this.isOverride && file.exists()) {
                Files.copy(responseBody.byteStream(), path, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(responseBody.byteStream(), path, new CopyOption[0]);
            }
            this.showInfo("FileSavePath: " + file.getAbsolutePath());
            return true;
        }
        return false;
    }

    public PoseidonResponse request() {
        PoseidonReq req = new PoseidonReq(this.gUrl, this.gMethod, this.gRequestBody, this.gFormParams, this.gFormEncodeParams, this.gHeaders, this.gFormData);
        Response response = null;
        try {
            JSONObject body;
            response = this.request(req, this.createAccessToken(), null);
            if (response == null) {
                throw new PoseidonException("response is null");
            }
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                throw new PoseidonException("response body is null");
            }
            boolean isStream = Poseidon.isStreamType(response);
            if (isStream) {
                return new PoseidonResponse(response);
            }
            String bodyStr = this.processResponseBody(response, true, false);
            ResponseBody responseBodyNew = ResponseBody.create(null, (String)bodyStr);
            try {
                body = JSONObject.parseObject((String)bodyStr);
            }
            catch (Exception e) {
                return new PoseidonResponse(response, responseBodyNew);
            }
            if (body == null || body.isEmpty()) {
                return new PoseidonResponse(response);
            }
            String at = this.resetAt(body);
            if (at != null) {
                this.showInfo("access token expire, repeat request...");
                response = this.request(req, at, null);
                return new PoseidonResponse(response);
            }
            return new PoseidonResponse(response, responseBodyNew);
        }
        catch (Exception e) {
            throw new PoseidonException(e, new PoseidonResponse(response, e.getMessage()));
        }
    }

    private String resetAt(JSONObject body) {
        String at = null;
        Integer status = body.getInteger("apim_status");
        if (Constants.EXPIRE_ACCESS_TOKEN_TIMEOUT_CODE.equals(status)) {
            at = this.createATByRt(body.getString("apim_refreshtoken"));
        } else if (Constants.EXPIRE_REFRESH_TOKEN_TIMEOUT_CODE.equals(status)) {
            ACCESS_TOKEN_MAPS.remove(this.pConfig.getAppKey() + this.pConfig.getAppSecret());
            at = this.createAT();
        }
        return at;
    }

    public String sync(PoseidonReq req) throws PoseidonException {
        String bodyStr;
        try (Response response = this.request(req, this.createAccessToken(), null);){
            bodyStr = this.processResponseBody(response);
            bodyStr = this.resetAccessToken(req, bodyStr);
        }
        catch (Exception e) {
            ACCESS_TOKEN_MAPS.remove(this.pConfig.getAppKey() + this.pConfig.getAppSecret());
            throw new PoseidonException(e);
        }
        return bodyStr;
    }

    public byte[] syncForBytes() throws PoseidonException {
        PoseidonReq req = new PoseidonReq(this.gUrl, this.gMethod, this.gRequestBody, this.gFormParams, this.gFormEncodeParams, this.gHeaders, this.gFormData);
        try {
            Response response = this.request(req, this.createAT(), null);
            this.processResponseBody(response, false, false);
            return response.body() != null ? response.body().bytes() : null;
        }
        catch (Exception e) {
            ACCESS_TOKEN_MAPS.remove(this.pConfig.getAppKey() + this.pConfig.getAppSecret());
            throw new PoseidonException(e);
        }
    }

    public InputStream syncForInputStream() throws PoseidonException {
        PoseidonReq req = new PoseidonReq(this.gUrl, this.gMethod, this.gRequestBody, this.gFormParams, this.gFormEncodeParams, this.gHeaders, this.gFormData);
        try {
            Response response = this.request(req, this.createAT(), null);
            this.processResponseBody(response, false, false);
            return response.body() != null ? response.body().byteStream() : null;
        }
        catch (Exception e) {
            ACCESS_TOKEN_MAPS.remove(this.pConfig.getAppKey() + this.pConfig.getAppSecret());
            throw new PoseidonException(e);
        }
    }

    public static boolean isStreamType(Response response) {
        MediaType mediaType = response.body() != null ? response.body().contentType() : null;
        String subtype = mediaType != null ? mediaType.subtype() : null;
        return OkHttpUtils.isStream(subtype);
    }

    public void async(PoseidonListener listener) throws PoseidonException {
        try {
            this.request(new PoseidonReq(this.gUrl, this.gMethod, this.gRequestBody, this.gFormParams, this.gFormEncodeParams, this.gHeaders, this.gFormData), this.createAT(), listener);
        }
        catch (IOException e) {
            throw new PoseidonException(e);
        }
    }

    private String resetAccessToken(PoseidonReq req, String bodyStr) throws IOException {
        JSONObject body;
        try {
            body = JSONObject.parseObject((String)bodyStr);
        }
        catch (Exception e) {
            ACCESS_TOKEN_MAPS.remove(this.pConfig.getAppKey() + this.pConfig.getAppSecret());
            return bodyStr;
        }
        if (body == null || body.isEmpty()) {
            return bodyStr;
        }
        String at = this.resetAt(body);
        if (at != null) {
            this.showInfo("access token expire repeat request...");
            Response response = this.request(req, at, null);
            bodyStr = this.processResponseBody(response);
            this.showInfo("second ResponseBody: " + bodyStr);
        }
        return bodyStr;
    }

    private String createAccessToken() {
        String act = ACCESS_TOKEN_MAPS.get(this.pConfig.getAppKey() + this.pConfig.getAppSecret());
        if (act != null) {
            this.showInfo("use already exist accessToken:" + act);
            return act;
        }
        return this.createAT();
    }

    public String createAT() {
        String rt = SecurityUtils.createToken(SecurityUtils.pin(this.pConfig), Constants.EXPIRE_REFRESH_TOKEN);
        return this.createATByRt(rt);
    }

    private String createATByRt(String rt) {
        String pin = SecurityUtils.pin(this.pConfig);
        String at = SecurityUtils.createToken(pin, Constants.EXPIRE_ACCESS_TOKEN);
        ACCESS_TOKEN_MAPS.put(this.pConfig.getAppKey() + this.pConfig.getAppSecret(), at);
        return SecurityUtils.accessToken(pin, this.pConfig.getAppKey(), this.pConfig.getAppSecret(), at, rt);
    }

    private synchronized Call getCall(PoseidonReq req, String accessToken) {
        FormBody.Builder builder;
        Request request = this.pConfig.getRequest();
        if (request != null) {
            this.showInfo("Use Custom Request");
            this.pConfig.autoRedirect();
            request = request.newBuilder().addHeader("apim-accesstoken", accessToken).build();
            return OkHttpUtils.getInstance().getHttpClient(this.pConfig, req).newCall(request);
        }
        if (StringUtils.isEmpty(req.url) || StringUtils.isEmpty(req.method)) {
            throw new PoseidonException("Url or Method is invalid");
        }
        RequestBody body = null;
        if (!StringUtils.isEmpty(req.requestBody)) {
            this.showInfo("requestBody: " + req.requestBody);
            body = RequestBody.create((MediaType)MediaType.parse((String)"application/json;charset=utf-8"), (String)req.requestBody);
        }
        if (CollectionUtils.isEmpty(req.headers)) {
            req.headers = new HashMap<String, String>(1);
        }
        if (!CollectionUtils.isEmpty(req.formParams) || !CollectionUtils.isEmpty(req.formEncodeParams)) {
            if (body != null) {
                throw new PoseidonException("formParams and jsonBody not coexist");
            }
            builder = new FormBody.Builder();
            if (!CollectionUtils.isEmpty(req.formParams)) {
                for (Map.Entry<String, String> entry : req.formParams.entrySet()) {
                    builder.addEncoded(entry.getKey(), entry.getValue());
                }
            }
            if (!CollectionUtils.isEmpty(req.formEncodeParams)) {
                for (Map.Entry<String, String> entry : req.formEncodeParams.entrySet()) {
                    builder.add(entry.getKey(), entry.getValue());
                }
            }
            body = builder.build();
            if (this.pConfig.isDebug()) {
                StringBuilder sb = new StringBuilder();
                FormBody formBody = (FormBody)body;
                for (int i = 0; i < formBody.size(); ++i) {
                    sb.append(formBody.encodedName(i)).append("=").append(formBody.encodedValue(i)).append(";");
                }
                this.debug("formParam: " + sb.toString());
            }
        }
        if (!CollectionUtils.isEmpty(req.formData)) {
            this.showInfo("formData: " + req.formData);
            if (body != null) {
                throw new PoseidonException("FormParams or JsonBody and FormData not coexist");
            }
            if (this.pConfig.isAutoRedirect()) {
                body = OkHttpUtils.buildMultipartBody(req.formData);
            } else {
                req.isFormData = true;
            }
        }
        builder = new Request.Builder().url(req.url).addHeader("apim-accesstoken", accessToken);
        String contentTypeValue = "application/json;charset=utf-8";
        for (Map.Entry<String, String> entry : req.headers.entrySet()) {
            String key = entry.getKey();
            if ("apim-accesstoken".equalsIgnoreCase(key)) {
                builder.removeHeader("apim-accesstoken");
            }
            if ("content-type".equalsIgnoreCase(key)) {
                contentTypeValue = entry.getValue();
            }
            builder.addHeader(key, entry.getValue());
        }
        if (body == null && HttpMethod.requiresRequestBody((String)req.method)) {
            body = RequestBody.create((MediaType)MediaType.parse((String)contentTypeValue), (String)"{}");
            builder.removeHeader("content-type");
        }
        request = builder.method(req.method, body).build();
        this.showInfo("headers: " + Poseidon.getHeadersInfo(request.headers(), null));
        return OkHttpUtils.getInstance().getHttpClient(this.pConfig, req).newCall(request);
    }

    public Response request(PoseidonReq req, String accessToken, PoseidonListener listener) throws IOException {
        if (this.pConfig.isDebug()) {
            this.debug("accessToken: " + accessToken);
            this.debug("accessKey: " + this.pConfig.getAppKey());
            this.debug("secretKey: " + this.pConfig.getAppSecret());
            this.debug("url: " + req.url);
            this.debug("method: " + req.method);
        }
        Call call = this.getCall(req, accessToken);
        if (listener == null) {
            return call.execute();
        }
        this.listener = listener;
        call.enqueue((Callback)this);
        return null;
    }

    public static String getTime() {
        SimpleDateFormat sdf1 = new SimpleDateFormat(pattern);
        return sdf1.format(new Date());
    }

    public void debug(String info) {
        try {
            sb.setLength(0);
            sb.append(Poseidon.getTime()).append(" [Poseidon] ").append(info).append("\n");
            System.out.write(sb.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new PoseidonException(e);
        }
    }

    public void showInfo(String info) {
        if (this.pConfig.isDebug()) {
            this.debug(info);
        }
    }

    public void onFailure(Call call, IOException e) {
        this.showInfo(e.getMessage());
        if (this.listener == null) {
            return;
        }
        this.listener.onFailure(e.getMessage());
    }

    public void onResponse(Call call, Response response) {
        String bodyStr;
        if (this.listener == null) {
            return;
        }
        try {
            bodyStr = this.processResponseBody(response);
        }
        catch (IOException e) {
            this.listener.onFailure(e.getMessage());
            return;
        }
        this.listener.onResponse(bodyStr);
    }

    private String processResponseBody(Response response) throws IOException {
        return this.processResponseBody(response, true, true);
    }

    private String processResponseBody(Response response, boolean isReturnString, boolean isProcessFile) throws IOException {
        if (response == null) {
            throw new PoseidonException("response is null");
        }
        this.showInfo("httpStatus: " + response.code());
        this.showInfo("responseHeaders: " + Poseidon.getHeadersInfo(response.headers(), null));
        if (isProcessFile && this.processRequestFile(response)) {
            return "SUCCESS";
        }
        String bodyStr = null;
        if (isReturnString) {
            bodyStr = response.body() != null ? response.body().string() : null;
            this.showInfo("responseBody: " + bodyStr);
        }
        if (!response.isSuccessful()) {
            throw new PoseidonException(bodyStr != null ? bodyStr : response.message());
        }
        return bodyStr;
    }

    public static String getHeadersInfo(Headers headers, String prefix) {
        if (headers == null) {
            return "";
        }
        Set names = headers.names();
        if (names.isEmpty()) {
            return "";
        }
        StringBuilder sbd = new StringBuilder();
        for (String key : names) {
            if (prefix != null && !key.startsWith(prefix)) continue;
            sbd.append(key).append("=").append(headers.values(key)).append(",");
        }
        if (sbd.length() > 0) {
            sbd.deleteCharAt(sbd.length() - 1);
        }
        return sbd.toString();
    }

    static {
        JSON.DEFAULT_PARSER_FEATURE &= ~Feature.UseBigDecimal.getMask();
        sb = new StringBuffer();
    }
}

